Attribute VB_Name = "Module1"
' This file is part of Poi_Loader.
'
' Poi_Loader is free software; you can redistribute it and/or modify it
' under the terms of the GNU General Public License as published by the
' Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.
'
' Poi_Loader is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
' See the GNU General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with Poi_Loader; if not, write to the Free Software, Inc.,
' 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Public x, y, Z, CountLines, Cnt, Cat_Id As Integer
Public S, Sql, Out As String
Public FileName, OutFname, Sect, Db, arr, DbLine, symCount
Public ObjFSO, objWSH, strFile
Public Eline, Op, Comm As String
Public CCommand As String
Public Added, Multi As Boolean
Public Type Categ
  Id As Integer
  LAB As String
  desc As String
  Enab As Integer
End Type
Public LAB As String
Public arrCat() As Categ
Public DefaultDb(9)
Global IC
Global BabelPath, SqlitePath

Public Const MIM_BACKGROUND As Long = &H2
Public Const MIM_APPLYTOSUBMENUS As Long = &H80000000
 
Public Type MENUINFO
    cbSize As Long
    fMask As Long
    dwStyle As Long
    cyMax As Long
    hbrBack As Long
    dwContextHelpID As Long
    dwMenuData As Long
End Type
 
Public Declare Function DrawMenuBar Lib "user32" (ByVal hWnd As Long) As Long
Public Declare Function GetSubMenu Lib "user32" (ByVal hMenu As Long, ByVal nPos As Long) As Long
Public Declare Function GetMenu Lib "user32" (ByVal hWnd As Long) As Long
Public Declare Function SetMenuInfo Lib "user32" (ByVal hMenu As Long, mi As MENUINFO) As Long
Public Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal _
    hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, _
    lParam As Any) As Long

Public Function IsItUni(Fname) As Boolean
Dim INF, Code

INF = FreeFile

Open Fname For Input As INF
    Line Input #INF, S
Close #INF

' Check if first line of file contains lat,lon and name
S = UCase(S)
Code = Asc(S)
If (InStr(S, "LAT") > 0) And (InStr(S, "LON") > 0) And (InStr(S, "NAME") > 0) Then
    If (Code > 64 And Code < 91) Or (Code > 96 And Code < 123) Then
        IsItUni = True
    Else
        IsItUni = False
    End If
End If
End Function

Public Sub RemBadChars(Fname)
Dim INF, tmp

tmp = FreeFile
Open frmMain.txtPoiPath.Text For Output As tmp
INF = FreeFile
Open frmMain.TxtTemp.Text & "\" & "tmp.gpx" For Input As INF
    Do While Not EOF(INF)
       Line Input #INF, S
       S = Replace(S, "&quot;", "")
       S = Replace(S, "&amp;", "")
       S = Replace(S, "&apos;", "")
       Print #tmp, S
    Loop
Close #INF
Close #tmp
frmMain.txtPoiPath.Text = frmMain.TxtTemp.Text & "\" & Fname & ".gpx"
ret = GetCommandOutput("cmd.exe /c del " & frmMain.TxtTemp.Text & "\" & "tmp.gpx", False, True, True)
If ret <> "" Then
   MsgBox "Failed to remove temporary file!" & vbCrLf & ret
End If
End Sub

Public Sub make_db()
Dim sql1, sql2, Pre As String

If FileExists(frmMain.TxtTemp.Text & "\poi.db") Then
  MsgBox "Failed to create - file already exists - " & frmMain.TxtTemp.Text & "\poi.db"
  Exit Sub
End If

sql1 = "CREATE TABLE category (cat_id integer PRIMARY KEY, label text, desc text, enabled integer);"
sql2 = "CREATE TABLE poi (poi_id integer PRIMARY KEY, lat real,lon real, label text,desc text,cat_id integer);"
ret = GetCommandOutput("cmd /c echo " & sql1 & " | " & IC & App.Path & "\sqlite3.exe " & _
                       IC & " " & IC & frmMain.TxtTemp.Text & "\poi.db" & IC)
Pre = "INSERT INTO category(label,desc,enabled) VALUES("

If ret <> "" Or InStr(ret, "error") > 0 Then
    MsgBox "Error Creating Category table in new db" & vbCrLf & sql1 & vbCrLf & ret
    Exit Sub
Else
   ret = GetCommandOutput("cmd /c echo " & sql2 & " | " & IC & App.Path & "\sqlite3.exe " & IC _
                          & " " & IC & frmMain.TxtTemp.Text & "\poi.db" & IC)
   If ret <> "" Or InStr(ret, "error") > 0 Then
      MsgBox "Error Creating Poi table in new db" & vbCrLf & sql2 & vbCrLf & ret
      Exit Sub
   End If
End If

For newcat = 0 To UBound(DefaultDb) - 1
    Sql = Pre & DefaultDb(newcat) & ");"
    ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & IC _
                           & " " & IC & frmMain.TxtTemp.Text & "\poi.db" & IC)
    If ret <> "" Or InStr(ret, "error") > 0 Then
       MsgBox "Error Adding category to new db" & vbCrLf & Sql & vbCrLf & ret
       Exit Sub
    End If
    Sql = ""
Next

MsgBox "Successfully created Default database!" & vbCrLf & vbCrLf & frmMain.TxtTemp & "\poi.db"
frmMain.txtDb.Text = frmMain.TxtTemp & "\poi.db"
End Sub


Public Sub GPX(Fname As String, cat As Integer, Tabl As String)
Dim Scat, CatFromSym, SelectedCat, Ucount, Ncount, RecCount, Savesql
Dim SYM, GotCat As Boolean
Dim Msg, strIndex, StrDrop, Dupout, IC As String
IC = Chr(34)
Ncount = 0
Ucount = 0
RecCount = 0
SYM = False
GotCat = False
Z = FreeFile
frmMain.MousePointer = 11
frmMain.cmdConv.Enabled = False
Out = "INSERT INTO " & Tabl & "(lat,lon,label,desc,cat_id) VALUES("

Open frmMain.TxtTemp.Text & "\DupsLog.txt" For Output As Z  ' records the sql resulting in a duplicate.
Print #Z, "The following records have duplicate lat,lon,category"
Print #Z, "If you really need to see these poi then alter either lat or lon by a "
Print #Z, "decimal or two."
Close #Z

' A Unique index created using everything but poi_id - removes the possibility of updateing
' from the same poi more than once.
StrDrop = "DROP INDEX IF EXISTS idxpoi;"       ' sql to remove index after sub
                                               ' sql to create index
strIndex = "CREATE UNIQUE INDEX IF NOT EXISTS idxpoi on poi (lat,lon,label,desc,cat_id);"
ret = GetCommandOutput("cmd /c echo " & strIndex & " | " & IC & App.Path & "\sqlite3.exe " & _
                        IC & " " & IC & frmMain.txtDb.Text & IC)
If ret <> "" Or InStr(ret, "error") Then
   MsgBox "Error unable to create index on table" & vbCrLf & strIndex & vbCrLf & ret
End If

get_cat_arr
For F = 0 To UBound(arrCat)
   If (arrCat(F).LAB = frmPickCat.CatText) Then SelectedCat = arrCat(F).Id
Next

' Count the number of records to be processed - used by progress/status bars
y = FreeFile
Open Fname For Input As y
Do While Not EOF(y)
    Line Input #y, S
    If Left$(S, 4) = "<wpt" Then
       RecCount = RecCount + 1
    End If
Loop
frmMain.ProgressBar1.Value = 0
frmMain.ProgressBar1.Max = RecCount

Z = FreeFile  ' Textfile to hold dups output.
Open frmMain.TxtTemp.Text & "\DupsLog.txt" For Append As Z
Close #y
Open Fname For Input As y           ' process gpxfile records
Line Input #y, S                    ' Pre-read first record
Do While Not EOF(y)
      
    Select Case True
    Case (Left$(S, 4) = "<wpt")      ' Start of new record - lat,lon
        
        Sect = Split(S, Chr(34))
        Sql = Out & Sect(1) & "," & Sect(3)
        SYM = False
        
    Case (InStr(S, "<name>") <> 0)   ' Label
       
        Sql = Sql & "," & Chr(34) & _
           Mid$(S, (InStr(S, ">") + 1), InStr(S, "</") - (InStr(S, ">") + 1)) & Chr(34)
    
    Case (InStr(S, "<desc>") <> 0)   ' desc
       
        Sql = Sql & "," & Chr(34) & _
           Mid$(S, (InStr(S, ">") + 1), InStr(S, "</") - (InStr(S, ">") + 1)) & Chr(34)
    
    Case (InStr(S, "<sym>") <> 0)    ' holds category
         
        CatFromSym = Mid$(S, (InStr(S, ">") + 1), InStr(S, "</") - (InStr(S, ">") + 1))
        ' set Scat to cat_id and GotCat to true if Category already exists
        If Not (frmMain.UseExisting And GotCat) Then
            If UBound(arrCat) - 1 > 0 Then
               For F = 0 To UBound(arrCat) - 1
                  If (arrCat(F).LAB = CatFromSym) Then ' Check exists
                     Scat = arrCat(F).Id
                     GotCat = True
                  End If
               Next
            End If
        End If
        Savesql = Sql
        If GotCat Then                      ' if allready there then use it
           Sql = Sql & "," & Scat & ");"
        Else                                ' if not then create cat from sym tab and use it
           New_Cat CatFromSym, "Please Edit This Description"
           Sql = Savesql & "," & arrCat(UBound(arrCat) - 1).Id & ");"
        End If
        SYM = True
        Savesql = ""
    
    Case (Left$(S, 5) = "</wpt")     ' End of record
       
        If Not SYM Then Sql = Sql & "," & cat & ");"  ' if there was no sym ( not needed anymore but what the hell )
        ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & _
                               IC & " " & IC & frmMain.txtDb.Text & IC)
        If ret <> "" Then
            If InStr(ret, "unique") > 0 Then
                Ncount = Ncount + 1
                Dupout = IC & Left(Mid$(Sql, 51), Len(Mid$(Sql, 50)) - 3) & IC
                Print #Z, Sql
            Else
                MsgBox "Failed to insert record " & vbCrLf & Sql & vbCrLf & ret
            End If
        Else
            Ucount = Ucount + 1
        End If
        Sql = Out
        frmMain.ProgressBar1.Value = frmMain.ProgressBar1.Value + 1
        frmMain.txtstatus.Text = "From a GPX file of " & RecCount & _
                            " Records inserting record No. " & frmMain.ProgressBar1.Value
    End Select
    ' update info output
    DoEvents
    If frmMain.UseExisting = False Then
        GotCat = False
    End If
    Line Input #y, S
    DoEvents
Loop

Close #y
Close #Z
frmMain.MousePointer = 0
frmMain.cmdConv.Enabled = True
If Ncount > 0 Then
    Msg = "There were " & Ucount & " Unique records inserted into db" & vbCrLf & _
           Ncount & " duplicate records were ignored. " & _
           "See " & frmMain.TxtTemp.Text & "\DupsLog.txt" & " for info"
Else
    Msg = "There were " & Ucount & " Unique records inserted into db" & vbCrLf & _
           Ncount & " duplicate records were ignored. "
End If
MsgBox Msg
ret = GetCommandOutput("cmd /c echo " & StrDrop & " | " & IC & App.Path & "\sqlite3.exe " & _
                        IC & " " & IC & frmMain.txtDb.Text & IC)
End Sub

Public Sub DispPoi(cat)
Dim Sp, Bit, ret
Dim Llab, Ldesc As Integer
get_cat_arr
Llab = 0
Ldesc = 0
frmDbo.List1.Clear
If cat = "" Then
    Sql = "select * from poi ;"
Else
    Sql = "select * from poi where cat_id = " & cat & ";"
End If
Comm = IC & App.Path & "\sqlite3.exe " & IC & " " & IC & frmMain.txtDb.Text & IC
ret = GetCommandOutput("cmd /c echo " & Sql & " | " & Comm)
If ret = "" Then
  ret = GetCommandOutput("cmd /c echo " & Sql & " | " & Comm, False, True)
  If ret <> "" Then
      MsgBox "Sub DispPoi Failed to retrieve records " & vbCrLf & Comm & vbCrLf & Sql
      Exit Sub
  End If
End If

Sp = Split(ret, vbCrLf)
For F = 0 To UBound(Sp) - 1
    Bit = Split(Sp(F), "|")
    If Len(Bit(3)) > Llab Then ' Find longest instance ( for padding )
        Llab = Len(Bit(3))
    End If
    If Len(Bit(4)) > Ldesc Then ' Find longest instance ( for padding )
       Ldesc = Len(Bit(4))
    End If
Next
For F = 0 To UBound(Sp) - 1
    Bit = Split(Sp(F), "|")
    For g = 0 To UBound(arrCat)
        If Bit(5) = arrCat(g).Id Then
            Bit(5) = Bit(5) & " - " & arrCat(g).LAB
        End If
    Next
    frmDbo.List1.AddItem Pad(5, Bit(0)) & "|" & Pad(12, Bit(1)) & "|" & _
                         Pad(12, Bit(2)) & "|" & Pad(Llab + 1, Bit(3)) & "|" & _
                         Pad(Ldesc + 1, Bit(4)) & "|" & Bit(5)
Next

End Sub

Public Sub Del_Poi_in_Cat(cat, catdesc)
Dim Sp, Bit, ret
Dim Llab, Ldesc As Integer
Llab = 0
Ldesc = 0
Sql = "delete from poi where cat_id = " & cat & ";"
Comm = IC & App.Path & "\sqlite3.exe " & IC & " " & IC & frmMain.txtDb.Text & IC1
ret = GetCommandOutput("cmd /c echo " & Sql & " | " & Comm)
If ret <> "" Then
    MsgBox "Failed in Delete Poi in Category " & catdesc & vbCrLf & ret
Else
    MsgBox "Deleted all poi in Category " & catdesc
End If
End Sub

Public Sub update_cat_desc()
' Change Category description
Dim Sql, Cols, Wich, IC
IC = Chr(34)
Cols = Split(frmDbo.List1.List(frmDbo.CIndex), "|")
Wich = Trim(Cols(0))
Sql = "update category set desc = " & IC & frmCatDesc.txtCatDesc.Text & IC & _
      " where cat_id = " & Wich & ";"
ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & _
                        IC & " " & IC & frmMain.txtDb.Text & IC)
If ret <> "" Then
    MsgBox "Update of Category failed" & vblfcr & ret
End If
End Sub

Public Sub Del_Cat()
Dim Sql, Cols, Wich, IC
Dim i As Integer
IC = Chr(34)
If frmDbo.List1.ListIndex = -1 Then Exit Sub
    For i = frmDbo.List1.ListCount - 1 To 0 Step -1
        If frmDbo.List1.Selected(i) = True Then
            Cols = Split(frmDbo.List1.List(i), "|")
            Wich = Trim(Cols(0))
            Sql = "select * from poi where cat_id = " & Wich & ";"
            ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & _
                                    IC & " " & IC & frmMain.txtDb.Text & IC)
            If ret <> "" Then
                MsgBox "This Category " & IC & Trim(Cols(1)) & IC & " has POI attached." & _
                vbCrLf & "Categories should only be removed where no POI are present." & vbCrLf & _
                        "Please remove all POI from " & IC & Trim(Cols(1)) & IC & " first!"
                GoTo SkipThisOne:
            Else
                Sql = "delete from category where cat_id = " & Wich & ";"
                ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & _
                                       "\sqlite3.exe " & IC & " " & IC & frmMain.txtDb.Text & IC)
                If ret <> "" Then MsgBox "Removal of Category failed" & vblfcr & ret
                frmDbo.List1.RemoveItem i
            End If
        End If
SkipThisOne:
    Next i
End Sub

Public Sub Del_Poi()
Dim Sql, Cols, Wich
Dim i As Integer
If frmDbo.List1.ListIndex = -1 Then Exit Sub
    For i = frmDbo.List1.ListCount - 1 To 0 Step -1
        If frmDbo.List1.Selected(i) = True Then
            Cols = Split(frmDbo.List1.List(i), "|")
            Wich = Trim(Cols(0))
            Sql = "delete from poi where poi_id = " & Wich & ";"
            ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & _
                                    IC & " " & IC & frmMain.txtDb.Text & IC)
            If ret <> "" Then MsgBox "Removal of Poi failed" & vbCrLf & ret
            frmDbo.List1.RemoveItem i
       End If
    Next i
End Sub


Public Sub Del_All_Poi()
Dim Sql
Sql = "delete from poi;"
ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & IC _
                        & " " & IC & frmMain.txtDb.Text & IC)
If ret <> "" Then MsgBox "Removal of All Poi failed" & vbCrLf & ret
End Sub

Public Sub Add_New_Poi(Lat, Lon, LAB, Des)
Dim Sql, cat
cat = frmcat.cmbCat.ListIndex + 1
Sql = "insert into poi(lat,lon,label,desc,cat_id) values(" & Chr(34) & Lat & _
               Chr(34) & "," & Chr(34) & Lon & Chr(34) & "," & Chr(34) & LAB & Chr(34) & _
               "," & Chr(34) & Des & Chr(34) & "," & Chr(34) & cat & Chr(34) & ");"
ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & IC _
                        & " " & IC & frmMain.txtDb.Text & IC)
If ret <> "" Then
    MsgBox "Addition of new Poi failed" & vbCrLf & ret
Else
    frmNewPoi.Hide
    Unload frmNewPoi
End If
End Sub

Public Sub New_Cat(S1, S2)
Dim Sql
Sql = "insert into category(label,desc,enabled) values(" & Chr(34) & _
      S1 & Chr(34) & "," & Chr(34) & S2 & Chr(34) & ",1);"
ret = GetCommandOutput("cmd /c echo " & Sql & " | " & IC & App.Path & "\sqlite3.exe " & IC & _
                       " " & IC & frmMain.txtDb.Text & IC)
If ret <> "" Or InStr(ret, "error") > 0 Then MsgBox "New Category failed" & vbCrLf & ret
Added = True
LAB = S1
get_cat
End Sub

Public Sub get_cat_arr()
Dim DLine
Sql = "select * from category ;"
Comm = IC & App.Path & "\sqlite3.exe " & IC & " " & IC & frmMain.txtDb.Text & IC
Op = GetCommandOutput("cmd /c echo " & Sql & " | " & Comm)
If Op = "" Or InStr(Op, "error") > 0 Then
   MsgBox "Error unable to retrieve records" & vbCrLf & Sql & vbCrLf & Comm
   frmPickCat.Hide
   Unload frmPickCat
   Exit Sub
End If
arr = Split(Op, vbCrLf)
ReDim arrCat(1) As Categ
For F = 0 To UBound(arr) - 1
    DLine = Split(arr(F), "|")
    arrCat(F).Id = DLine(0)
    arrCat(F).LAB = DLine(1)
    arrCat(F).desc = DLine(2)
    arrCat(F).Enab = DLine(3)
    ReDim Preserve arrCat(UBound(arrCat()) + 1)
Next
End Sub


Public Sub get_cat()
Dim Op As String
Cnt = 0
Sql = "select * from category ;"
Comm = IC & App.Path & "\sqlite3.exe " & IC & " " & IC & frmMain.txtDb.Text & IC
Op = GetCommandOutput("cmd /c echo " & Sql & " | " & Comm)
If InStr(Op, "error near line") < 1 Then
    arr = Split(Op, vbCrLf)
    ReDim arrCat(1) As Categ
    For F = 0 To UBound(arr) - 1
        DbLine = Split(arr(F), "|")
        arrCat(F).Id = DbLine(0)
        arrCat(F).LAB = DbLine(1)
        arrCat(F).desc = DbLine(2)
        arrCat(F).Enab = DbLine(3)
        ReDim Preserve arrCat(UBound(arrCat()) + 1)
        DoEvents
        Cat_Id = DbLine(0)
    Next
    DoEvents
    Added = False
Else
    MsgBox "ERrror getting DB!" & vbCrLf & Op
End If
End Sub

Public Function Pad(L As Integer, Op As Variant) As String ' add padding for neat columns
Pad = Op & Space$(L - Len(Op))
End Function

Public Function FileExists(FilePath As String) As Boolean
Dim FileToTest
Set FileToTest = CreateObject("Scripting.FileSystemObject")
FileExists = FileToTest.FileExists(FilePath)
End Function

Public Function CheckForCatInSym(Fname As String) As String
Dim Bits
Dim lCat, gCat As String
symCount = 0
y = FreeFile
Open Fname For Input As y
Do While Not EOF(y)
    Line Input #y, S
    If InStr(S, "<sym>") > 0 Then
        lCat = Mid$(S, (InStr(S, ">") + 1))
        lCat = Left$(lCat, Len(lCat) - (Len(lCat) - InStr(lCat, "<") + 1))
        If lCat <> "" And gCat <> lCat Then
            symCount = symCount + 1
        End If
        gCat = lCat
    End If
Loop
Close #y
Select Case symCount
    Case 0
        CheckForCatInSym = ""
    Case 1
        CheckForCatInSym = lCat
    Case Else
        CheckForCatInSym = "Multi"
End Select
End Function

Public Sub GPX_Out(Fname, cat)
Dim Fout, Category, Outln
Dim GotSym As Boolean
GotSym = False
Fout = frmMain.txtOp.Caption
Category = "  <sym>" & cat & "</sym>"
Z = FreeFile
Open Fout For Output As Z
y = FreeFile
Open Fname For Input As y
Do While Not EOF(y)
    Line Input #y, S
    Select Case True
        Case (InStr(S, "<sym>") > 0)
            Print #Z, Category
            GotSym = True
        Case (InStr(S, "</wpt>") > 0)
            If GotSym Then
                Print #Z, S
                GotSym = False
            Else
                Print #Z, Category
                Print #Z, S
            End If
        Case Else
            Print #Z, S
    End Select
    S = ""
Loop
Close #Z
Close #y
End Sub

Public Sub DispCat()
Dim Sp, Bit
Dim Llab, Ldesc As Integer
Llab = 1
Ldesc = 1
frmDbo.List1.Clear
Sql = "select * from category ;"
Comm = IC & App.Path & "\sqlite3.exe" & IC & " " & IC & frmMain.txtDb.Text & IC
CCommand = "cmd /c echo " & Sql & " | " & Comm
ret = GetCommandOutput(CCommand)
If ret = "" Then
  MsgBox "In Sub DispCat. Failed to retrieve data from DB" & vbCrLf & ret & vbCrLf & Sql & vbCrLf & CCommand
End If
Sp = Split(ret, vbCrLf)
For F = 0 To UBound(Sp) - 1
    Bit = Split(Sp(F), "|")
    If Len(Bit(1)) > Llab Then
        Llab = Len(Bit(1))
    End If
    If Len(Bit(2)) > Ldesc Then
        Ldesc = Len(Bit(2))
    End If
Next
For F = 0 To UBound(Sp) - 1
    Bit = Split(Sp(F), "|")
    frmDbo.List1.AddItem Pad(4, Bit(0)) & "|" & Pad(Llab + 1, Bit(1)) & "|" & _
                          Pad(Ldesc + 1, Bit(2)) & "|" & Pad(3, Bit(3))
Next
End Sub

Public Sub Export_To_GPX(cat)
Dim Fout, Z, ret, Sp, Col, CSql, lCat, LCount
Z = FreeFile
LCount = 0

CSql = "select * from category ;"
Comm = IC & App.Path & "\sqlite3.exe " & IC & " " & frmMain.txtDb.Text
Op = GetCommandOutput("cmd /c echo " & CSql & " | " & Comm)
arr = Split(Op, vbCrLf)
ReDim arrCat(1) As Categ
For F = 0 To UBound(arr) - 1
    DbLine = Split(arr(F), "|")
    arrCat(F).Id = DbLine(0)
    arrCat(F).LAB = DbLine(1)
    arrCat(F).desc = DbLine(2)
    arrCat(F).Enab = DbLine(3)
    ReDim Preserve arrCat(UBound(arrCat()) + 1)
Next

Comm = IC & App.Path & "\sqlite3.exe " & IC & " " & IC & frmMain.txtDb.Text & IC
If cat = "" Then                                                 ' Full Dump
    Fout = frmMain.TxtTemp.Text & "\DbDump.gpx"
    Sql = "select * from poi ;"
Else                                                             ' Poi in category dump
    Fout = frmMain.TxtTemp.Text & "\" & cat & ".gpx"
    For C = 0 To UBound(arrCat) - 1
       If arrCat(C).LAB = cat Then lCat = arrCat(C).Id
    Next
    Sql = "select * from poi where cat_id = " & lCat & " ;"
End If
ret = GetCommandOutput("cmd /c echo " & Sql & " | " & Comm)
If ret = "" Or InStr(ret, "error") > 0 Then
   MsgBox "Failed to retrieve records" & vbCrLf & Sql & vbCrLf & ret
   Exit Sub
Else
   Sp = Split(ret, vbCrLf)
End If

Open Fout For Output As Z

' output header details to file
Print #Z, "<?xml version=" & Chr(34) & "1.0" & Chr(34) & " encoding=" & Chr(34) & _
          "UTF-8" & Chr(34) & "?>"
frmDbo.List1.AddItem "<?xml version=" & Chr(34) & "1.0" & Chr(34) & " encoding=" & Chr(34) & _
          "UTF-8" & Chr(34) & "?>"
Print #Z, "<gpx version = " & Chr(34) & "1.0" & Chr(34) & ">"
frmDbo.List1.AddItem "<gpx version = " & Chr(34) & "1.0" & Chr(34) & ">"

' output body of file
For F = 0 To UBound(Sp) - 1
    Col = Split(Sp(F), "|")
    Print #Z, "<wpt lat=" & Chr(34) & Col(1) & Chr(34) & " lon=" & Chr(34) & Col(2) & _
              Chr(34) & ">"
    frmDbo.List1.AddItem "<wpt lat=" & Chr(34) & Col(1) & Chr(34) & " lon=" & Chr(34) & Col(2) & _
              Chr(34) & ">"
    Print #Z, "  <name>" & Col(3) & "</name>"
    frmDbo.List1.AddItem "  <name>" & Col(3) & "</name>"
    Print #Z, "  <desc>" & Col(4) & "</desc>"
    frmDbo.List1.AddItem "  <desc>" & Col(4) & "</desc>"
    If cat = "" Then
         For C = 0 To UBound(arrCat) - 1
            If arrCat(C).Id = Col(5) Then ret = arrCat(C).LAB
         Next
    Else
       ret = cat
    End If
    Print #Z, "  <sym>" & ret & "</sym>"
    frmDbo.List1.AddItem "  <sym>" & ret & "</sym>"
    Print #Z, "</wpt>"
    frmDbo.List1.AddItem "</wpt>"
    LCount = LCount + 1
Next

' Tail of file
Print #Z, "</gpx>"
frmDbo.List1.AddItem "</gpx>"
Close #Z
MsgBox "Exported " & LCount & " records to " & Fout
End Sub

