Attribute VB_Name = "Module1"
' This file is part of Poi_Loader.
'
' Poi_Loader is free software; you can redistribute it and/or modify it
' under the terms of the GNU General Public License as published by the
' Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.
'
' Poi_Loader is distributed in the hope that it will be useful, but
' WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
' See the GNU General Public License for more details.
'
' You should have received a copy of the GNU General Public License
' along with Poi_Loader; if not, write to the Free Software, Inc.,
' 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

Public X, Y, Z, CountLines, Cnt, Cat_Id As Integer
Public S, Sql, Out As String
Public FileName, OutFname, Sect, DB, arr, DbLine, symCount, dbStats
Public ObjFSO, objWSH, strFile
Public Eline, Op, Comm As String
Public CCommand As String
Public cat As String
Public Added, Multi As Boolean
Public DataBase As Long
Public DoingRadius As Boolean

Public Type DbRet
  NumRec As Long
  Rows As Variant
  ErrRet As String
End Type
Public DBans As DbRet
Public Type Categ
  ID As Integer
  Lab As String
  desc As String
  Enab As Integer
  Count As Integer
End Type
Public Type Ptab
  ID As Integer
  lat As Variant
  lon As Variant
  Label As String
  desc As String
  cat As Variant
End Type
Public arrPoi() As Ptab
Public Lab As String
Public arrCat() As Categ
Public DefaultDb(9)
Global IC
Global BabelPath, SqlitePath

Public Const MIM_BACKGROUND As Long = &H2
Public Const MIM_APPLYTOSUBMENUS As Long = &H80000000
 
Public Type MENUINFO
    cbSize As Long
    fMask As Long
    dwStyle As Long
    cyMax As Long
    hbrBack As Long
    dwContextHelpID As Long
    dwMenuData As Long
End Type
 
Public Declare Sub sqlite3_open Lib "SQLite3VB.dll" (ByVal FileName As String, ByRef handle As Long)
Public Declare Sub sqlite3_close Lib "SQLite3VB.dll" (ByVal DB_Handle As Long)
Public Declare Function sqlite3_last_insert_rowid Lib "SQLite3VB.dll" (ByVal DB_Handle As Long) As Long
Public Declare Function sqlite3_changes Lib "SQLite3VB.dll" (ByVal DB_Handle As Long) As Long
Public Declare Function sqlite_get_table Lib "SQLite3VB.dll" (ByVal DB_Handle As Long, ByVal SQLString As String, ByRef ErrStr As String) As Variant()
Public Declare Function sqlite_libversion Lib "SQLite3VB.dll" () As String ' Now returns a BSTR
Public Declare Function number_of_rows_from_last_call Lib "SQLite3VB.dll" () As Long
Public Declare Function DrawMenuBar Lib "user32" (ByVal hWnd As Long) As Long
Public Declare Function GetSubMenu Lib "user32" (ByVal hMenu As Long, ByVal nPos As Long) As Long
Public Declare Function GetMenu Lib "user32" (ByVal hWnd As Long) As Long
Public Declare Function SetMenuInfo Lib "user32" (ByVal hMenu As Long, mi As MENUINFO) As Long
Public Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long
Public Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Public Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal _
    hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, _
    lParam As Any) As Long

Public Function IsItUni(fname) As Boolean
Dim INF, Code
INF = FreeFile
Open fname For Input As INF
    Line Input #INF, S
Close #INF
' Check if first line of file contains lat,lon and name
S = UCase(S)
Code = Asc(S)
If (InStr(S, "LAT") > 0) And (InStr(S, "LON") > 0) And (InStr(S, "NAME") > 0) Then
    If (Code > 64 And Code < 91) Or (Code > 96 And Code < 123) Then
        IsItUni = True
    Else
        IsItUni = False
    End If
End If
End Function

Public Sub make_db(Name, msg As Boolean)
Dim fname, sql1, sql2, Pre As String
If Name = "" Then fname = frmMain.TxtTemp.Text & "\poi.db" Else fname = Name
If FileExists(fname) Then
  MsgBox "Failed to create " & fname & " file already exists!! "
  Exit Sub
Else
  sqlite3_open fname, DataBase
End If

sql1 = "CREATE TABLE category (cat_id integer PRIMARY KEY, label text, desc text, enabled integer);"
sql2 = "CREATE TABLE poi (poi_id integer PRIMARY KEY, lat real,lon real, label text,desc text,cat_id integer);"
Pre = "INSERT INTO category(label,desc,enabled) VALUES("
DBans = DBaccess(sql1)
If DBans.ErrRet <> "" Then
    MsgBox "Error Creating Category table in new db" & vbCrLf & sql1 & vbCrLf & DBans.ErrRet
    Exit Sub
Else
   DBans = DBaccess(sql2)
   If DBans.ErrRet <> "" Then
      MsgBox "Error Creating Poi table in new db" & vbCrLf & sql2 & vbCrLf & DBans.ErrRet
      Exit Sub
   End If
End If

For newcat = 0 To UBound(DefaultDb) - 1
    Sql = Pre & DefaultDb(newcat) & ");"
    DBans = DBaccess(Sql)
    If DBans.ErrRet <> "" Then
       MsgBox "Error Adding category to new db" & vbCrLf & Sql & vbCrLf & DBans.ErrRet
       Exit Sub
    End If
    Sql = ""
Next

If msg Then MsgBox "Successfully created database!" & vbCrLf & vbCrLf & fname
If Name = "" Then
  frmMain.txtDb.Text = frmMain.TxtTemp & "\poi.db"
End If
End Sub

Public Sub GPX(fname As String, Lab, cat, DB As String)
' Insert records from Gpx file into DB
Dim Scat, CatFromSym, Ucount, Ncount, RecCount, Savesql, Prog
Dim SYM, GotCat, Override As Boolean
Dim msg, strIndex, StrDrop, Dupout, IC As String
Dim CatSiz As Integer
IC = Chr(34)
Ncount = 0
Ucount = 0
RecCount = 0
Prog = 0
SYM = False
GotCat = False
Z = FreeFile
frmMain.MousePointer = 11
frmMain.cmdConv.Enabled = False
Out = "INSERT INTO poi(lat,lon,label,desc,cat_id) VALUES("

Open frmMain.TxtTemp.Text & "\DupsLog.txt" For Output As Z  ' records the sql resulting in a duplicate.
Print #Z, "The following records have duplicate lat,lon,category"
Print #Z, "If you really need to see these poi then alter either lat or lon by a "
Print #Z, "decimal or two."
Close #Z

' A Unique index created using everything but poi_id - removes the possibility of updateing
' from the same poi more than once.
StrDrop = "DROP INDEX IF EXISTS idxpoi;"
strIndex = "CREATE UNIQUE INDEX IF NOT EXISTS idxpoi on poi (lat,lon,label,desc,cat_id);"
DBans = DBaccess(strIndex)
If DBans.ErrRet <> "" Then
   MsgBox "Error unable to create index on table" & vbCrLf & strIndex & vbCrLf & ret
End If

' Count the number of records to be processed - used by progress/status bars
Y = FreeFile
Open fname For Input As Y
Do While Not EOF(Y)
    Line Input #Y, S
    If InStr(S, "<wpt") Then
       RecCount = RecCount + 1
    End If
Loop
Close #Y
frmMain.ProgressBar1.Value = 0
frmMain.ProgressBar1.Max = RecCount

Z = FreeFile  ' Textfile to hold dups output.
Open frmMain.TxtTemp.Text & "\DupsLog.txt" For Append As Z
Y = FreeFile

' Main Work
Open fname For Input As Y           ' process gpxfile records
Line Input #Y, S                    ' Pre-read first record
Do While Not EOF(Y)
      
    Select Case True
    Case InStr(S, "<wpt")     ' Start of new record - lat,lon
        
        Prog = Prog + 1
        Sect = Split(S, Chr(34))
        Sql = Out & Sect(1) & "," & Sect(3)
        SYM = False
        
    Case (InStr(S, "<name>") <> 0)   ' Label
       
        Sql = Sql & "," & Chr(34) & _
           Mid$(S, (InStr(S, ">") + 1), InStr(S, "</") - (InStr(S, ">") + 1)) & Chr(34)
    
    Case (InStr(S, "<desc>") <> 0)   ' desc
       
        Sql = Sql & "," & Chr(34) & _
           Mid$(S, (InStr(S, ">") + 1), InStr(S, "</") - (InStr(S, ">") + 1)) & Chr(34)
    
    Case (InStr(S, "<sym>") <> 0)    ' holds category
         
        CatFromSym = Mid$(S, (InStr(S, ">") + 1), InStr(S, "</") - (InStr(S, ">") + 1))
         
        If cat = 0 And Lab = "" Then    ' Multiple categories
            savSql = Sql
            For f = 0 To UBound(arrCat) - 1
               If (arrCat(f).Lab = CatFromSym) Then ' Check exists
                   Sql = Sql & "," & arrCat(f).ID & ");"
                   GotCat = True
               End If
            Next
            If GotCat = False Then
               New_Cat CatFromSym, "Please Edit This Description"
               Sql = savSql & "," & arrCat(UBound(arrCat) - 1).ID & ");"
            End If
        Else
           Sql = Sql & "," & cat & ");"
        End If
            
    Case InStr(S, "</wpt")     ' End of record
       
        DBans = DBaccess(Sql)
        If DBans.ErrRet <> "" Then
            If InStr(DBans.ErrRet, "unique") > 0 Then
                Ncount = Ncount + 1
                Dupout = IC & Left(Mid$(Sql, 51), Len(Mid$(Sql, 50)) - 3) & IC
                Print #Z, Sql
            Else
                MsgBox "Failed to insert record " & vbCrLf & Sql & vbCrLf & DBans.ErrRet
            End If
        Else
            Ucount = Ucount + 1
        End If
        Sql = Out
        If Prog Mod 5 = 0 Then
            frmMain.ProgressBar1.Value = Prog
            frmMain.txtstatus.Text = "From a GPX file of " & RecCount & _
                                     " Records inserting record No. " & Prog
            DoEvents
        End If
    End Select
    ' update info output
    If frmMain.UseExisting = False Then
        GotCat = False
    End If
    Line Input #Y, S
Loop

Close #Y
Close #Z
frmMain.MousePointer = 0
frmMain.cmdConv.Enabled = True
If Ncount > 0 Then
    msg = "There were " & Ucount & " Unique records inserted into db" & vbCrLf & _
           Ncount & " duplicate records were ignored. " & _
           "See " & frmMain.TxtTemp.Text & "\DupsLog.txt" & " for info"
Else
    msg = "There were " & Ucount & " Unique records inserted into db" & vbCrLf & _
           Ncount & " duplicate records were ignored. "
End If
If Not DoingRadius Then MsgBox msg
DBans = DBaccess(StrDrop)
End Sub

Public Sub getStats()
Dim Sp, Bit, ret, lcat
Dim RecCount, Ncat, Bwidth, Bheight, Bleft, Btop, Offset, FullCount, Wid As Integer
Dim BarColor(8) As Long
Dim barmap(5) As String
Offset = 425
Ncat = UBound(arrCat)
Bwidth = 7500 / Ncat
Btop = 660
FullCount = 0
Load frmStats
barmap(4) = App.Path & "\images\cont.jpg"
barmap(3) = App.Path & "\images\cont1.jpg"
barmap(2) = App.Path & "\images\cont2.jpg"
barmap(1) = App.Path & "\images\cont3.jpg"
barmap(0) = App.Path & "\images\cont4.jpg"

' Horizontal grid
For f = 330 To 3630 Step 300
    frmStats.Controls.Add "vb.line", "gri" & f
    With frmStats.Controls("gri" & f)
        .Visible = True
        .BorderColor = &HC0C0C0
        .X1 = 810
        .Y1 = f
        .X2 = (UBound(arrCat) * Bwidth) + Bwidth + Offset
        .Y2 = f
    End With
Next

' Top Line
frmStats.Controls.Add "vb.line", "HorizT"
With frmStats.Controls("HorizT")
    .Visible = True
    .BorderColor = &HC0C0C0
    .X1 = 810
    .X2 = ((UBound(arrCat) * Bwidth) + Bwidth) + Offset
    .Y1 = 330
    .Y2 = 330
End With

' Bottom Line
frmStats.Controls.Add "vb.line", "HorizB"
With frmStats.Controls("HorizB")
    .Visible = True
    .BorderColor = &HC0C0C0
    .X1 = 810
    .X2 = (UBound(arrCat) * Bwidth) + Bwidth + Offset
    .Y1 = 3330
    .Y2 = 3330
End With

Dim CStep, Biggest
Biggest = 0
For f = 1 To UBound(arrCat) + 1
      
    
    Wid = Offset + (f * Bwidth)
    
    frmStats.Controls.Add "vb.line", "Lin" & f
    With frmStats.Controls("Lin" & f)
        .BorderColor = &HC0C0C0
        .Visible = True
        .X1 = Wid
        .Y1 = 330
        .X2 = Wid
        .Y2 = 3330
     End With
      
    If f <= UBound(arrCat) Then
    
        frmStats.Controls.Add "vb.image", "But" & arrCat(f).ID
        With frmStats.Controls("But" & arrCat(f).ID)
            .Visible = True
            .Stretch = True
            .BorderStyle = 1
            .Top = Btop
            .Width = Bwidth
            .Left = Wid
            .Height = 1
            .ZOrder 0
        End With
        
        frmStats.Controls.Add "vb.label", "Catl" & f
        With frmStats.Controls("Catl" & f)
            .Visible = True
            .Width = 300
            .Top = 3100
            .BackStyle = 0
            .Left = Wid
            .Caption = "  " & arrCat(f).ID
         End With
    
    End If
Next

Sql = "select * from poi ;"
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then                                             ' Error trapping
    MsgBox "Failed to retrieve records " & vbCrLf & Sql
    Exit Sub
End If


For f = 1 To UBound(arrCat)
  Sql = "select * from poi where cat_id = " & arrCat(f).ID & ";"
  DBans = DBaccess(Sql)
  arrCat(f).Count = DBans.NumRec
  If arrCat(f).Count > Biggest Then Biggest = arrCat(f).Count
Next

CStep = 2660 / Biggest                                           ' stepsize
T = 0
For f = 1 To UBound(arrCat)
    On Error Resume Next
    frmStats.Controls("But" & arrCat(f).ID).Picture = LoadPicture(barmap(T))
    frmStats.Controls("But" & arrCat(f).ID).ToolTipText = arrCat(f).ID & "," & IC & _
                      arrCat(f).Lab & IC & "," & IC & arrCat(f).desc & IC & "," & En & _
                      "," & arrCat(f).Count & " Records"
    FullCount = FullCount + arrCat(f).Count
    
    If arrCat(f).Count > 0 Then
        With frmStats.Controls("But" & arrCat(f).ID)
            .Height = CStep * arrCat(f).Count
            If .Height < 225 Then
               .Top = 3030 - .Height
            Else
               .Top = (3060 - (CStep * arrCat(f).Count))
            End If
            .Caption = arrCat(f).Count
        End With
    Else
        With frmStats.Controls("But" & arrCat(f).ID)
            .Height = 5
            .Top = 3000
        End With
    End If

    ' cycle images
    T = T + 1
    If T > 4 Then T = 0

Next

frmStats.lblTotal.Caption = frmStats.lblTotal.Caption & FullCount
frmStats.Show
      
End Sub

Public Sub DispPoi(cat)
Dim Sp, Bit, ret
Dim Llab, Ldesc As Integer
frmDbo.txtAnnounce.Text = "Accessing database .... Please wait."
DoEvents
Llab = 0
Ldesc = 0
ClearList
If cat = "" Then
    Sql = "select * from poi ;"
Else
    Sql = "select * from poi where cat_id = " & cat & ";"
End If
DBans = DBaccess(Sql)
If DBans.ErrRet = "" Then
    If DBans.NumRec = 0 Then
        frmDbo.txtAnnounce.Text = "No record to display"
        Exit Sub
    End If
    mRowCnt = number_of_rows_from_last_call
    Listem mRowCnt, DBans.Rows
        
        If cat = "" Then
            frmDbo.txtAnnounce.Text = "Displayed " & DBans.NumRec & " records for full DB"
        Else
            frmDbo.txtAnnounce.Text = "Displayed " & DBans.NumRec & " records for category " & cat
        End If
End If
End Sub

Public Sub Del_Poi_in_Cat(cat, catdesc)
Dim Sp, Bit, ret
Dim Llab, Ldesc As Integer
Llab = 0
Ldesc = 0
Sql = "delete from poi where cat_id = " & cat & ";"
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then
    MsgBox "Failed in Delete Poi in Category " & catdesc & vbCrLf & DBans.ErrRet
Else
    MsgBox "Deleted all poi in Category " & catdesc
End If
End Sub

Public Sub update_cat_desc()
' Change Category description
Dim Sql, Cols, Wich, IC
IC = Chr(34)
Sql = "update category set desc = " & IC & frmCatDesc.txtCatDesc.Text & IC & _
      " where cat_id = " & cat & ";"
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then
    MsgBox "Update of Category failed" & vblfcr & DBans.ErrRet
End If
End Sub

Public Sub ClearList()
frmDbo.lvResults.ColumnHeaders.Clear
frmDbo.lvResults.ListItems.Clear
End Sub

Public Sub Del_Cat()
Dim Sql, Cols, Wich, IC
Dim Itm As ListItem
IC = Chr(34)
Dim index As Integer
For index = frmDbo.lvResults.ListItems.Count To 1 Step -1
  Set Itm = frmDbo.lvResults.ListItems(index)
  If Itm.Selected Then
          Wich = frmDbo.lvResults.ListItems(index).Text
          Sql = "select * from poi where cat_id = " & Wich & ";"
          DBans = DBaccess(Sql)
          If DBans.NumRec = 0 Then
              Sql = "delete from category where cat_id = " & Wich & ";"
              DBans = DBaccess(Sql)
              If DBans.ErrRet <> "" Then
                  MsgBox "Removal of Category failed" & vblfcr & DBans.ErrRet
              Else
                  frmDbo.lvResults.ListItems.Remove (index)
              End If
          Else
              MsgBox "This Category " & IC & Wich & IC & " has " & IC & DBans.NumRec & IC & " POI attached." & _
              vbCrLf & "Categories should only be removed where no POI are present." & vbCrLf & _
                      "Please remove all POI from the category first!"
              Exit Sub
          End If
      End If
  Next
End Sub

Public Sub Del_Poi()
Dim Sql, Cols, Wich
Dim index As Integer
For index = frmDbo.lvResults.ListItems.Count To 1 Step -1
  Set Itm = frmDbo.lvResults.ListItems(index)
  If Itm.Selected Then
    Wich = frmDbo.lvResults.ListItems(index).Text
    Sql = "delete from poi where poi_id = " & Wich & ";"
    DBans = DBaccess(Sql)
    If DBans.ErrRet <> "" Then
        MsgBox "Removal of Point of Interest failed" & vblfcr & DBans.ErrRet
    Else
        frmDbo.lvResults.ListItems.Remove (index)
    End If
  End If
  Wich = ""
Next
End Sub


Public Sub Del_All_Poi()
Dim Sql
Sql = "delete from poi;"
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then MsgBox "Removal of All Poi failed" & vbCrLf & DBans.ErrRet
End Sub

Public Sub Add_New_Poi(lat, lon, Lab, Des)
Dim Sql
Sql = "insert into poi(lat,lon,label,desc,cat_id) values(" & Chr(34) & lat & _
               Chr(34) & "," & Chr(34) & lon & Chr(34) & "," & Chr(34) & Lab & Chr(34) & _
               "," & Chr(34) & Des & Chr(34) & "," & Chr(34) & cat & Chr(34) & ");"
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then
    MsgBox "Addition of new Poi failed" & vbCrLf & DBans.ErrRet
Else
    frmNewPoi.Hide
    Unload frmNewPoi
End If
End Sub

Public Sub New_Cat(S1, S2)
Dim Sql
Dim N As Integer
Dim Cats As Integer
Dim IDent As Integer
Sql = "insert into category(label,desc,enabled) values(" & Chr(34) & _
      S1 & Chr(34) & "," & Chr(34) & S2 & Chr(34) & ",1);"
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then
    MsgBox "New Category failed" & vbCrLf & DBans.ErrRet
Else
    Added = True
    Lab = S1
    IDent = arrCat(UBound(arrCat)).ID + 1
    ' insert new cat in array
    N = UBound(arrCat) + 1
    ReDim Preserve arrCat(N) As Categ
    Cats = N - 1
    arrCat(Cats).ID = IDent
    arrCat(Cats).Lab = S1
    arrCat(Cats).desc = S2
    arrCat(Cats).Enab = "1"
    If frmPickCat.Visible Then
        frmPickCat.cmbCat.Clear
        For f = 0 To UBound(arrCat)
         frmPickCat.cmbCat.AddItem arrCat(f).Lab
        Next
    End If
End If
End Sub

'Public Function Pad(L As Integer, Op As Variant) As String ' add padding for neat columns
'Pad = Op & Space$(L - Len(Op))
'End Function

Public Function FileExists(FilePath) As Boolean
Dim FileToTest
Set FileToTest = CreateObject("Scripting.FileSystemObject")
FileExists = FileToTest.FileExists(FilePath)
End Function

Public Function CheckForCatInSym(fname As String) As String
Dim Bits
Dim lcat, gCat As String
symCount = 0
Y = FreeFile
Open fname For Input As Y
Do While Not EOF(Y)
    Line Input #Y, S
    If InStr(S, "<sym>") > 0 Then
        lcat = Mid$(S, (InStr(S, ">") + 1))
        lcat = Left$(lcat, Len(lcat) - (Len(lcat) - InStr(lcat, "<") + 1))
        If lcat <> "" And gCat <> lcat Then
            symCount = symCount + 1
        End If
        gCat = lcat
    End If
Loop
Close #Y
Select Case symCount
    Case 0
        CheckForCatInSym = "None"
    Case 1
        CheckForCatInSym = lcat
    Case Else
        CheckForCatInSym = "Multi"
End Select
End Function

Public Function basename(P)
  Dim Bits, Last
  Bits = Split(P, "\")
  Last = Bits(UBound(Bits))
  basename = Last
End Function

Public Function dirname(D)
  Dim Bits, Bit, First
  Bits = Split(D, "\")
  For Bit = 0 To (UBound(Bits) - 1)
    First = First & Bits(Bit) & "\"
  Next Bit
  dirname = First
End Function

Public Sub kml_extract_trk(Fin)
Dim Outlna, Fout, Lone, Ltwo, tmp, Orig, Segcount, Twodel
Segcount = 0
Lone = "<?xml version=" & Chr(34) & "1.0" & Chr(34) & "?>"
Ltwo = "<gpx version = " & Chr(34) & "1.0" & Chr(34) & " creator=" & Chr(34) & "Poi_Loader" & Chr(34) & " xmlns=" & _
         Chr(34) & "http://www.topografix.com/GPX/1/0" & Chr(34) & ">"
tmp = Split(basename(Fin), ".")
Fout = frmMain.TxtTemp.Text & "\" & tmp(0) & "_trk." & tmp(1)
Twodel = 2

Z = FreeFile
Open Fout For Output As Z
Print #Z, Lone;
Print #Z, Chr(10);
Print #Z, Ltwo;
Print #Z, Chr(10);
Y = FreeFile

' Ohh for grep and wc - Count segments
Open Fin For Input As Y
Do While Not EOF(Y)
    Line Input #Y, S
    If InStr(S, "<trkseg") Then
       Segcount = Segcount + 1
    End If
Loop
Close #Y
Orig = Segcount

Open Fin For Input As Y
Line Input #Y, S
Do While Not (EOF(Y) Or (InStr(S, "<trk>") > 0))
    Line Input #Y, S
Loop
Print #Z, S;
Print #Z, Chr(10);
Do While Not EOF(Y)
    Line Input #Y, S
    Select Case True
      Case (InStr(S, "<trk>") > 0)
         If Segcount = Orig Then
            Print #Z, S;
            Print #Z, Chr(10);
         End If
      Case (InStr(S, "<trkpt") > 0)
         S = Replace(S, ">", "/>")
         Print #Z, S;
         Print #Z, Chr(10);
      Case (InStr(S, "<trkseg>") > 0), (InStr(S, "<desc") > 0), (InStr(S, "</gpx") > 0)
         Print #Z, S;
         Print #Z, Chr(10);
      Case (InStr(S, "</trkseg>") > 0)
         Segcount = Segcount - 1
         Print #Z, S;
         Print #Z, Chr(10);
      Case (InStr(S, "</trk>") > 0)
         If Segcount = 0 Then
            Print #Z, S;
            Print #Z, Chr(10);
         End If
     End Select
Loop
Close #Z
Close #Y

End Sub

Public Sub GPX_Out(Fin, Fout, cat)
Dim Category, Outln, Tname, Tdesc
Dim GotSym, Dbreak As Boolean
Dim FileOut As String
Dbreak = False
GotSym = False
If Fout = "" Then
  FileCopy Fin, frmMain.TxtTemp.Text & "\tmp.tmp"
  Fout = frmMain.TxtTemp.Text & "\tmp.tmp"
End If
Category = "  <sym>" & cat & "</sym>"
Z = FreeFile
Open Fout For Output As Z
Y = FreeFile
Open Fin For Input As Y
Do While Not EOF(Y)
    Line Input #Y, S
    S = LTrim(S)
    'remove dross
    S = Replace(S, "&quot;", "")
    S = Replace(S, "&amp;", "")
    S = Replace(S, "&apos;", "")
    Select Case True
        
        Case (InStr(S, "<name") > 0)
            Print #Z, "  " & S
            
'        Case (InStr(S, "<cmt") > 0)
'            Print #Z, "  " & S
            
        Case (InStr(S, "<desc") > 0)
            'fix possible line breaks
            If (InStr(S, "</desc>") = 0) Then
               Dbreak = True
               Tdesc = S
            Else
               Print #Z, "  " & S
            End If
' fix possible line breaks
        Case ((InStr(S, "</desc>") > 0) And Dbreak)
            Dbreak = False
            Print #Z, Tdesc & S
            Tdesc = ""
        Case (InStr(S, "<sym>") > 0)
            Print #Z, Category
            GotSym = True
        
        Case (InStr(S, "</wpt>") > 0)
            If GotSym Then
                Print #Z, S
                GotSym = False
            Else
              If cat <> "" Then
                Print #Z, Category
                Print #Z, S
              Else
                Print #Z, S
              End If
            End If
        
        Case Else
            Print #Z, S
    
    End Select
    S = ""
Loop
Close #Z
Close #Y
If Fout = "" Then
  FileCopy Fout, frmMain.txtPoiPath.Text
  CCommand = "cmd /c del " & Fout
  Shell CCommand, vbHide
  FileOut = Fout
  If FileExists(Fout) Then
     MsgBox "Failed to delete " & Fout & " Please manually delete "
  End If
End If
End Sub


Public Sub DispCat()
Dim Sp, Bit
ClearList
Sql = "select * from category ;"
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then
  MsgBox "In Sub DispCat. Failed to retrieve data from DB" & vbCrLf & DBans.ErrRet & vbCrLf & Sql & vbCrLf & CCommand
Else
  Listem DBans.NumRec, DBans.Rows
End If

End Sub

Public Sub Export_To_GPX(cat, msg As Boolean)
Dim Fout, Z, ret, Sp, Col, CSql, lcat
Dim mstr As String
Dim mCurColumn As String
Dim i As Integer
Dim Rec As Variant
'   Decide Filename
If cat = "" Then                                                 ' Full Dump
    Fout = frmMain.TxtTemp.Text & "\DbDump.mmp"
    Sql = "select * from poi ;"
Else                                                             ' Poi in category dump
    For C = 0 To UBound(arrCat) - 1
       If arrCat(C).ID = cat Then lcat = arrCat(C).Lab
    Next
    Fout = frmMain.TxtTemp.Text & "\" & lcat & ".mmp"
    Sql = "select * from poi where cat_id = " & cat & " ;"
End If
' get records
DBans = DBaccess(Sql)
If DBans.ErrRet <> "" Then
   MsgBox "Failed to retrieve records" & vbCrLf & Sql & vbCrLf & DBans.ErrRet
   Exit Sub
End If
' transfer to sane array
ReDim Preserve arrPoi(DBans.NumRec) As Ptab
For Each Rec In DBans.Rows
    mstr = Rec
    If i = 0 Then
        mCurColumn = mstr
    Else
        Select Case mCurColumn
           Case "poi_id"
              arrPoi(i).ID = mstr
           Case "lat"
              arrPoi(i).lat = mstr
           Case "lon"
              arrPoi(i).lon = mstr
           Case "label"
              arrPoi(i).Label = mstr
           Case "desc"
              arrPoi(i).desc = mstr
           Case "cat_id"
              arrPoi(i).cat = mstr
        End Select
    End If
    i = i + 1
    If i > DBans.NumRec Then
        i = 0
    End If
Next Rec

' Export to file
Z = FreeFile
Open Fout For Output As Z
' header
Print #Z, "<?xml version=" & Chr(34) & "1.0" & Chr(34) & " encoding=" & Chr(34) & _
          "UTF-8" & Chr(34) & "?>"
Print #Z, "<gpx version = " & Chr(34) & "1.0" & Chr(34) & ">"
' body
For f = 1 To UBound(arrPoi)
    Print #Z, "<wpt lat=" & Chr(34) & arrPoi(f).lat & Chr(34) & " lon=" & Chr(34) & _
              arrPoi(f).lon & Chr(34) & ">"
    Print #Z, "  <name>" & arrPoi(f).Label & "</name>"
    Print #Z, "  <desc>" & arrPoi(f).desc & "</desc>"
    For C = 0 To UBound(arrCat) - 1
       If arrCat(C).ID = arrPoi(f).cat Then ret = arrCat(C).Lab
    Next
    Print #Z, "  <sym>" & ret & "</sym>"
    Print #Z, "</wpt>"
Next
' Tail
Print #Z, "</gpx>"
Close #Z
If msg Then MsgBox "Exported " & DBans.NumRec & " records to " & Fout
End Sub

Public Function DBaccess(ByVal Sql As String) As DbRet
    On Error GoTo ERR_TRAP
    Dim mRowCnt As Long
    Dim LRows As Variant
    Dim mErrStr As String
    Dim mCurColumn As String
    Dim Lerror As String
    Lerror = ""
    If Sql = "" Then Exit Function

    If DataBase > 0 Then
        LRows = sqlite_get_table(DataBase, Sql, mErrStr)
        If mErrStr <> "" Then
            Lerror = mErrStr
        Else
            mRowCnt = number_of_rows_from_last_call
        End If
    End If
    DBaccess.ErrRet = Lerror
    DBaccess.NumRec = mRowCnt
    DBaccess.Rows = LRows
    Exit Function
ERR_TRAP:
    DBaccess.ErrRet = Err.Description
    DBaccess.NumRec = mRowCnt
    DBaccess.Rows = LRows
End Function

Public Function getcat()

End Function

Public Sub Listem(mRowCnt, Rows)

Dim Rec As Variant
Dim mstr As String
Dim mCurColumn As String
Dim LI As ListItem
Dim i As Long
    For Each Rec In Rows
        mstr = Rec
        If i = 0 Then
            mCurColumn = mstr
            frmDbo.lvResults.ColumnHeaders.Add , mCurColumn, mCurColumn
        Else
            If frmDbo.lvResults.ColumnHeaders.Count = 1 Then
                frmDbo.lvResults.ListItems.Add , , mstr
            ElseIf frmDbo.lvResults.ColumnHeaders.Count > 1 Then
                Set LI = frmDbo.lvResults.ListItems(i)
                LI.SubItems(frmDbo.lvResults.ColumnHeaders.Count - 1) = mstr
            End If
        End If
        i = i + 1
        If i > mRowCnt Then
            i = 0
        End If
    Next

End Sub

Public Sub get_cat()
ReDim arrCat(0) As Categ
Dim Rec As Variant
Dim mstr As String
Dim Sql, mCurColumn As String
Dim LI As ListItem
Dim Col As Integer
Dim i As Long
Sql = "select * from category ;"
DBans = DBaccess(Sql)
If DBans.ErrRet = "" Then
    ReDim arrCat(DBans.NumRec) As Categ
    For Each Rec In DBans.Rows
        mstr = Rec
        If i = 0 Then
            mCurColumn = mstr
        Else
            Select Case mCurColumn
               Case "cat_id"
                  arrCat(i).ID = mstr
               Case "label"
                  arrCat(i).Lab = mstr
               Case "desc"
                  arrCat(i).desc = mstr
               Case "enabled"
                  arrCat(i).Enab = mstr
            End Select
        End If
        i = i + 1
        If i > DBans.NumRec Then
            i = 0
        End If
     Next Rec
Else
   MsgBox "Failed to retrieve categories " & vbCrLf & DBans.ErrRet
End If
End Sub

Private Function Radius(dist, lat, lon, Infile, Outfile) As String
' Use Gpsbabel to create the gpx file - put into temporary file
    Comm = "cmd /c " & IC & IC & BabelPath & IC & " -i gpx -f " & IC & Infile & _
           IC & " -x radius,distance=" & dist & ",lat=" & lat & ",lon=" & _
           lon & " -o gpx -F " & IC & Outfile & IC & IC
    Radius = Shell(Comm, vbHide)
End Function

Private Function Width_Limit(errordist, arcdist, Infile, Dumpfile, Tempfile) As String
' FIXME - Not yet in use UNTESTED. No Screen to collect data yet
' Use Gpsbabel to first simplify the route
   Comm = "cmd /C " & IC & IC & BabelPath & IC & " -r -i gpx -f " & Infile & _
     IC & " -x simplify,error=" & arcdist & " -o gpx -F " & Tempfile & IC & IC
   Sleep 2000
' now create an arfile
  Comm = "cmd /C " & IC & IC & BabelPath & IC & " -r -i gpx -f " & Tempfile & _
     " -o arc -F arc" & Tempfile & IC & IC
   Sleep 2000
' Use arcfile against dbdump to create the final poifile
  Comm = "cmd /C " & IC & IC & BabelPath & IC & " -i gpx -f " & Dumpfile & _
    " -x arc,file=arcCardifftoLondon.gpx,distance=" & errordist & " -o gpx -F arc" & _
    Infile & IC & IC
End Function

Public Sub Radlim()
Dim DbPath, tmp, fname, Initdb
Initdb = frmMain.txtDb.Text
DoingRadius = True
Load frmRadlim
frmRadlim.Show
While Not frmRadlim.Done
    Sleep 100
    DoEvents
Wend
DbPath = dirname(frmRadlim.RadPath)
tmp = basename(frmRadlim.RadPath)
If InStr(tmp, ".db") Then
  fname = Replace(tmp, ".db", "")
Else
  If InStr(tmp, ".") Then fname = Left(tmp, (InStr(tmp, ".") - 1)) Else fname = tmp
End If
Export_To_GPX "", False
Radius frmRadlim.RadRad, frmRadlim.RadLat, frmRadlim.RadLon, frmMain.TxtTemp.Text & _
       "\DbDump.mmp", frmMain.TxtTemp.Text & "\" & fname & ".mmp"
make_db DbPath & fname & ".db", False
frmMain.txtDb.Text = DbPath & fname & ".db"
frmMain.txtPoiPath.Text = frmMain.TxtTemp.Text & "\" & fname & ".mmp"
frmMain.cmdConv_Click
MsgBox "Radius limiting of " & Initdb & " complete." & vbCrLf & vbCrLf & _
       "Database created is " & DbPath & fname & ".db" & vbCrLf & _
       "Two mmp files were created in your temp directory :- " & vbCrLf & vbCrLf & _
       frmMain.TxtTemp.Text & "\" & fname & ".mmp" & " - Radius limited gpx format" & vbCrLf & _
       frmMain.TxtTemp.Text & "\DbDump.mmp - Full databse Dump in gpx format"
DoingRadius = False
End Sub

